/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataLabels;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Circular;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.SumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class JChart_2D_Radar
extends JChart_2D_Circular {
    private Point[] m_riserStartPoints;
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_2D_Radar(perspective);
        }
    };

    private JChart_2D_Radar(Perspective perspective) {
        super(perspective);
    }

    public void calc() {
        super.calc();
    }

    public void calcStandard() {
        boolean isAreaRiser = !this.m_Perspective.getJGraphType().isRadarLine();
        this.m_bAlignMultiYBars = this.m_Perspective.getAlignMultiYBars();
        this.m_bIsThisAComboWithBar = this.isComboWithBar();
        this.m_bIsComboWithNonBar = this.isComboWithNonBar();
        this.m_DataLabels = new DataLabels(this.m_Perspective);
        this.createAxes(false);
        if (this.m_bAbsolute) {
            this.calcDataAbsolute();
        } else if (this.m_bStacked) {
            this.calcDataStacked();
        } else if (this.m_gt.isScalingPercent()) {
            this.calcDataPercent();
        }
        if (isAreaRiser) {
            this.drawRisers();
        }
        this.calcAxes();
        this.drawAxisBody();
        if (!isAreaRiser) {
            this.drawRisers();
        }
        this.drawUserLines();
        this.drawDataLabels();
    }

    protected void drawRisers() {
        if (this.m_Perspective.getJGraphType().isRadarLine()) {
            if (this.m_Perspective.getConnectLineMarkers()) {
                this.drawLines(true);
            }
            this.drawMarkers();
        } else {
            this.drawAreaRisers();
        }
    }

    protected double processOneStackedValue(int s, int g, INumericAxis yAxisObj, double fValue, SumObj sumObj) {
        int nRiser;
        boolean bY2;
        boolean bPositive = fValue >= 0.0;
        double fNewSum = sumObj.getSum(bPositive, bY2 = yAxisObj == this.m_Y2Axis, nRiser = this.m_depth2D.getSeriesType(s)) + fValue;
        boolean bOffScale = this.isIgnoredOffScale(yAxisObj, fNewSum);
        if (bOffScale) {
            this.m_dataOK[s][g] = false;
        } else {
            sumObj.setSum(bPositive, bY2, nRiser, fNewSum);
        }
        double fAngle = this.getO1Axis().getCenterCoord(g);
        double fRadius = yAxisObj.getValueCoord(fNewSum);
        Point ptCoord = new Point(0, 0);
        if (bOffScale && this.m_gt.equals(127)) {
            fRadius = 0.0;
        }
        Rectangle rFrame = this.m_Perspective.getFrameRect(true);
        Dimension frameDim = new Dimension(rFrame.width, rFrame.height);
        Point frameCenter = new Point(rFrame.x + rFrame.width / 2, rFrame.y + rFrame.height / 2);
        AxisUtils.polarToCartesian(ptCoord, fAngle, fRadius, frameDim, frameCenter, this.m_Perspective.getVC());
        this.numericXCoord[s][g] = ptCoord.x;
        this.numericYCoord[s][g] = ptCoord.y;
        if (this.isAxisAscending(s)) {
            AxisUtils.polarToCartesian(ptCoord, fAngle, 0.0, frameDim, frameCenter, this.m_Perspective.getVC());
            this.m_riserStartPoints[g] = ptCoord;
        } else {
            AxisUtils.polarToCartesian(ptCoord, fAngle, 1.0, frameDim, frameCenter, this.m_Perspective.getVC());
            this.m_riserStartPoints[g] = ptCoord;
        }
        return fNewSum;
    }

    protected void calcDataStacked() {
        this.numericXCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_riserStartPoints = new Point[this.m_nTotalGroups];
        super.calcDataStacked();
    }

    public boolean wantLegend() {
        return true;
    }

    protected void drawAreaRisers() {
        boolean colorBySeries;
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        boolean bl = colorBySeries = this.m_Perspective.getEffectiveColorMode() == 1;
        if (gEnum.size() < 3) {
            return;
        }
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasNext()) {
                int point2y;
                int point2x;
                int point1y;
                int point1x;
                int g = gEnum.next();
                int gNext = gEnum.peekNext();
                if (gNext < 0) {
                    gNext = gEnum.get(0);
                }
                if (s == sEnum.get(0)) {
                    point1x = this.m_riserStartPoints[g].x;
                    point1y = this.m_riserStartPoints[g].y;
                    point2x = this.m_riserStartPoints[gNext].x;
                    point2y = this.m_riserStartPoints[gNext].y;
                } else {
                    int sPrev = sEnum.peekBefore(s);
                    point1x = this.numericXCoord[sPrev][g];
                    point1y = this.numericYCoord[sPrev][g];
                    point2x = this.numericXCoord[sPrev][gNext];
                    point2y = this.numericYCoord[sPrev][gNext];
                }
                Polygon polygon = new Polygon();
                polygon.addPoint(point1x, point1y);
                polygon.addPoint(point2x, point2y);
                polygon.addPoint(this.numericXCoord[s][gNext], this.numericYCoord[s][gNext]);
                polygon.addPoint(this.numericXCoord[s][g], this.numericYCoord[s][g]);
                polygon.addPoint(point1x, point1y);
                IBlackBox blackBox = this.assignSeriesColor(s, g);
                DrawFactory.createPolygon(this.getDrawContainer(), new IdentObj(500, s), polygon, blackBox, this.m_rClip);
            }
        }
    }

    protected Rectangle calcDataValuePosition(int s, int g, int nDataTextPosition, int nDataTextPositionSecondary, Dimension labelDim) {
        int width = labelDim.width;
        int height = labelDim.height;
        int x1 = this.numericXCoord[s][g];
        int y1 = this.numericYCoord[s][g];
        Rectangle rDataValue = new Rectangle(x1, y1, width, height);
        return rDataValue;
    }
}

