/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Point;
import java.awt.Rectangle;

public class Gridlines2D {
    static final int BACK_WALL = 0;
    static final int LEFT_WALL = 700;
    static final int RIGHT_WALL = 800;
    static final int BOTTOM_WALL = 900;
    static final int GRID_OFFSET = 0;
    static final int TICK_OFFSET = 10000;
    static final int TICKSIZE = 250;
    private static final double TICK_DEPTH_FACTOR = 1.15;
    private Perspective m_Perspective;
    private Rectangle m_rFrame;
    private Point m_ptFrameDepthOffset;
    private int m_nPosVC;
    private IdentObj m_id;
    private IBlackBox m_blackBox;
    private double m_fLineWidth;
    private Java2DLine m_line2D = null;
    private boolean m_bRightDepthWall;
    private boolean m_bLeftDepthWall;

    public Gridlines2D(Perspective persp, Rectangle rFrame, Point ptFrameDepthOffset, int nPosVC, int nOffset, IdentObj id, IBlackBox blackBox, double fLineWidth) {
        this.m_Perspective = persp;
        this.m_rFrame = rFrame;
        this.m_ptFrameDepthOffset = ptFrameDepthOffset;
        this.m_nPosVC = nPosVC;
        this.m_id = id;
        this.m_blackBox = blackBox;
        this.m_fLineWidth = fLineWidth;
        this.m_line2D = new Java2DLine(this.m_Perspective);
        this.setLeftAndRightDepthWalls();
    }

    private void setLeftAndRightDepthWalls() {
        if (this.m_Perspective.getDepthRadius() == 0) {
            if (this.m_ptFrameDepthOffset.x == 0) {
                this.m_bLeftDepthWall = false;
                this.m_bRightDepthWall = false;
            } else {
                this.m_bLeftDepthWall = this.m_ptFrameDepthOffset.x > 0;
                this.m_bRightDepthWall = this.m_ptFrameDepthOffset.x < 0;
            }
        } else {
            this.m_bLeftDepthWall = this.m_ptFrameDepthOffset.x >= 0;
            this.m_bRightDepthWall = this.m_ptFrameDepthOffset.x < 0;
        }
    }

    protected void releaseReferences() {
        this.m_Perspective = null;
    }

    private void drawGridline(int nAddToMakeNewMiscID, int x1, int y1, int x2, int y2, Rectangle rClip) {
        IdentObj newID = this.m_id;
        int nMisc = this.m_id.getMiscID();
        newID = newID.changeMisc(nMisc + nAddToMakeNewMiscID);
        this.m_line2D.createLine(this.m_id, newID, x1, y1, x2, y2, this.m_blackBox, rClip, this.m_fLineWidth);
    }

    public void calcGridTicksVertNormal() {
        int nLeftBottom = this.m_rFrame.x;
        int nRightTop = this.m_rFrame.width + nLeftBottom;
        this.drawGridline(0, nLeftBottom, this.m_nPosVC, nRightTop, this.m_nPosVC, this.m_rFrame);
        if (this.m_bLeftDepthWall) {
            Rectangle rClip = new Rectangle(nLeftBottom - this.m_ptFrameDepthOffset.x, this.m_rFrame.y, this.m_ptFrameDepthOffset.x, this.m_rFrame.height);
            this.drawGridline(700, nLeftBottom, this.m_nPosVC, nLeftBottom - this.m_ptFrameDepthOffset.x, this.m_nPosVC - this.m_ptFrameDepthOffset.y, rClip);
        } else if (this.m_bRightDepthWall) {
            Rectangle rClip = new Rectangle(nRightTop, this.m_rFrame.y, -this.m_ptFrameDepthOffset.x, this.m_rFrame.height);
            this.drawGridline(800, nRightTop, this.m_nPosVC, nRightTop - this.m_ptFrameDepthOffset.x, this.m_nPosVC - this.m_ptFrameDepthOffset.y, rClip);
        }
    }

    public void calcGridTicksVertNormalOutside(boolean bLeftSide, boolean bRightSide) {
        Rectangle rClip;
        int nLeftBottom = this.m_rFrame.x;
        int nRightTop = this.m_rFrame.width + nLeftBottom;
        this.drawGridline(0, nLeftBottom, this.m_nPosVC, nRightTop, this.m_nPosVC, this.m_rFrame);
        if (bLeftSide) {
            if (this.m_bLeftDepthWall) {
                this.drawGridline(700, nLeftBottom, this.m_nPosVC, (int)(-1.15 * (double)this.m_ptFrameDepthOffset.x + (double)nLeftBottom), (int)(-1.15 * (double)this.m_ptFrameDepthOffset.y + (double)this.m_nPosVC), this.m_rFrame);
            } else {
                this.drawGridline(0, nLeftBottom, this.m_nPosVC, nLeftBottom - 250, this.m_nPosVC, null);
            }
        } else if (this.m_bLeftDepthWall) {
            rClip = new Rectangle(nLeftBottom - this.m_ptFrameDepthOffset.x, this.m_rFrame.y, this.m_ptFrameDepthOffset.x, this.m_rFrame.height);
            this.drawGridline(700, nLeftBottom, this.m_nPosVC, nLeftBottom - this.m_ptFrameDepthOffset.x, this.m_nPosVC - this.m_ptFrameDepthOffset.y, rClip);
        }
        if (bRightSide) {
            if (this.m_bRightDepthWall) {
                this.drawGridline(800, nRightTop, this.m_nPosVC, (int)(-1.15 * (double)this.m_ptFrameDepthOffset.x + (double)nRightTop), (int)(-1.15 * (double)this.m_ptFrameDepthOffset.y + (double)this.m_nPosVC), null);
            } else {
                this.drawGridline(0, nRightTop, this.m_nPosVC, nRightTop + 250, this.m_nPosVC, null);
            }
        } else if (this.m_bRightDepthWall) {
            rClip = new Rectangle(nRightTop, this.m_rFrame.y, -this.m_ptFrameDepthOffset.x, this.m_rFrame.height);
            this.drawGridline(800, nRightTop, this.m_nPosVC, nRightTop - this.m_ptFrameDepthOffset.x, this.m_nPosVC - this.m_ptFrameDepthOffset.y, rClip);
        }
    }

    public void calcGridTicksVertInside(boolean bLeftSide, boolean bRightSide) {
        int nLeftBottom = this.m_rFrame.x;
        int nRightTop = this.m_rFrame.width + nLeftBottom;
        if (bLeftSide) {
            if (this.m_bLeftDepthWall) {
                this.drawGridline(10700, (int)(-((double)this.m_ptFrameDepthOffset.x) / 1.15 + (double)nLeftBottom), (int)(-((double)this.m_ptFrameDepthOffset.y) / 1.15 + (double)this.m_nPosVC), -this.m_ptFrameDepthOffset.x + nLeftBottom, -this.m_ptFrameDepthOffset.y + this.m_nPosVC, null);
            } else {
                this.drawGridline(10000, nLeftBottom, this.m_nPosVC, nLeftBottom + 250, this.m_nPosVC, null);
            }
        }
        if (bRightSide) {
            if (this.m_bRightDepthWall) {
                this.drawGridline(10800, nRightTop - this.m_ptFrameDepthOffset.x, this.m_nPosVC - this.m_ptFrameDepthOffset.y, (int)(-((double)this.m_ptFrameDepthOffset.x) / 1.15 + (double)nRightTop), (int)(-((double)this.m_ptFrameDepthOffset.y) / 1.15 + (double)this.m_nPosVC), null);
            } else {
                this.drawGridline(10000, nRightTop, this.m_nPosVC, nRightTop - 250, this.m_nPosVC, null);
            }
        }
    }

    public void calcGridTicksVertOutside(boolean bLeftSide, boolean bRightSide) {
        int nLeftBottom = this.m_rFrame.x;
        int nRightTop = this.m_rFrame.width + nLeftBottom;
        if (bLeftSide) {
            if (this.m_bLeftDepthWall) {
                this.drawGridline(10700, (int)(-1.15 * (double)this.m_ptFrameDepthOffset.x + (double)nLeftBottom), (int)(-1.15 * (double)this.m_ptFrameDepthOffset.y + (double)this.m_nPosVC), -this.m_ptFrameDepthOffset.x + nLeftBottom, -this.m_ptFrameDepthOffset.y + this.m_nPosVC, null);
            } else {
                this.drawGridline(10000, nLeftBottom, this.m_nPosVC, nLeftBottom - 250, this.m_nPosVC, null);
            }
        }
        if (bRightSide) {
            if (this.m_bRightDepthWall) {
                this.drawGridline(10800, nRightTop - this.m_ptFrameDepthOffset.x, this.m_nPosVC - this.m_ptFrameDepthOffset.y, (int)(-1.15 * (double)this.m_ptFrameDepthOffset.x + (double)nRightTop), (int)(-1.15 * (double)this.m_ptFrameDepthOffset.y + (double)this.m_nPosVC), null);
            } else {
                this.drawGridline(10000, nRightTop, this.m_nPosVC, nRightTop + 250, this.m_nPosVC, null);
            }
        }
    }

    public void calcGridTicksVertSpanning(boolean bLeftSide, boolean bRightSide) {
        int nLeftBottom = this.m_rFrame.x;
        int nRightTop = this.m_rFrame.width + nLeftBottom;
        if (bLeftSide) {
            if (this.m_bLeftDepthWall) {
                this.drawGridline(10700, (int)(-1.15 * (double)this.m_ptFrameDepthOffset.x + (double)nLeftBottom), (int)(-1.15 * (double)this.m_ptFrameDepthOffset.y + (double)this.m_nPosVC), (int)(-((double)this.m_ptFrameDepthOffset.x) / 1.15 + (double)nLeftBottom), (int)(-((double)this.m_ptFrameDepthOffset.y) / 1.15 + (double)this.m_nPosVC), null);
            } else {
                this.drawGridline(10000, nLeftBottom + 250, this.m_nPosVC, nLeftBottom - 250, this.m_nPosVC, null);
            }
        }
        if (bRightSide) {
            if (this.m_bRightDepthWall) {
                this.drawGridline(10800, (int)(-((double)this.m_ptFrameDepthOffset.x) / 1.15 + (double)nRightTop), (int)(-((double)this.m_ptFrameDepthOffset.y) / 1.15 + (double)this.m_nPosVC), (int)(-1.15 * (double)this.m_ptFrameDepthOffset.x + (double)nRightTop), (int)(-1.15 * (double)this.m_ptFrameDepthOffset.y + (double)this.m_nPosVC), null);
            } else {
                this.drawGridline(10000, nRightTop - 250, this.m_nPosVC, nRightTop + 250, this.m_nPosVC, null);
            }
        }
    }

    public void calcGridTicksHorizNormal() {
        int nLeftBottom = this.m_rFrame.y;
        int nRightTop = this.m_rFrame.height + nLeftBottom;
        this.drawGridline(0, this.m_nPosVC, nLeftBottom, this.m_nPosVC, nRightTop, this.m_rFrame);
        if (this.m_bLeftDepthWall || this.m_bRightDepthWall) {
            Rectangle rClip = new Rectangle(this.m_rFrame.x - this.m_ptFrameDepthOffset.x, nLeftBottom - this.m_ptFrameDepthOffset.y, this.m_rFrame.width + this.m_ptFrameDepthOffset.x, this.m_ptFrameDepthOffset.y);
            this.drawGridline(700, this.m_nPosVC, nLeftBottom, this.m_nPosVC - this.m_ptFrameDepthOffset.x, nLeftBottom - this.m_ptFrameDepthOffset.y, rClip);
        }
    }

    public void calcGridTicksHorizNormalTicks(boolean bLeftSide, boolean bRightSide) {
        int nLeftBottom = this.m_rFrame.y;
        int nRightTop = this.m_rFrame.height + nLeftBottom;
        this.drawGridline(0, this.m_nPosVC, nLeftBottom, this.m_nPosVC, nRightTop, this.m_rFrame);
        if (bLeftSide) {
            if (this.m_bLeftDepthWall || this.m_bRightDepthWall) {
                this.drawGridline(700, this.m_nPosVC, nLeftBottom, (int)(-1.15 * (double)this.m_ptFrameDepthOffset.x + (double)this.m_nPosVC), (int)(-1.15 * (double)this.m_ptFrameDepthOffset.y + (double)nLeftBottom), null);
            } else {
                this.drawGridline(10000, this.m_nPosVC, nLeftBottom, this.m_nPosVC, nLeftBottom - 250, null);
            }
        } else if (this.m_bLeftDepthWall || this.m_bRightDepthWall) {
            this.drawGridline(900, this.m_nPosVC, nLeftBottom, this.m_nPosVC - this.m_ptFrameDepthOffset.x, nLeftBottom - this.m_ptFrameDepthOffset.y, null);
        }
        if (bRightSide) {
            this.drawGridline(10800, this.m_nPosVC, nRightTop, this.m_nPosVC, nRightTop + 250, null);
        }
    }

    public void calcGridTicksHorizInside(boolean bLeftSide, boolean bRightSide) {
        int nLeftBottom = this.m_rFrame.y;
        int nRightTop = this.m_rFrame.height + nLeftBottom;
        if (bLeftSide) {
            if (this.m_bLeftDepthWall || this.m_bRightDepthWall) {
                this.drawGridline(10700, (int)(-((double)this.m_ptFrameDepthOffset.x) / 1.15 + (double)this.m_nPosVC), (int)(-((double)this.m_ptFrameDepthOffset.y) / 1.15 + (double)nLeftBottom), -this.m_ptFrameDepthOffset.x + this.m_nPosVC, -this.m_ptFrameDepthOffset.y + nLeftBottom, null);
            } else {
                this.drawGridline(10000, this.m_nPosVC, nLeftBottom, this.m_nPosVC, nLeftBottom + 250, null);
            }
        }
        if (bRightSide) {
            this.drawGridline(10800, this.m_nPosVC, nRightTop, this.m_nPosVC, nRightTop - 250, null);
        }
    }

    public void calcGridTicksHorizOutside(boolean bLeftSide, boolean bRightSide) {
        int nLeftBottom = this.m_rFrame.y;
        int nRightTop = this.m_rFrame.height + nLeftBottom;
        if (bLeftSide) {
            if (this.m_bLeftDepthWall || this.m_bRightDepthWall) {
                this.drawGridline(10700, -this.m_ptFrameDepthOffset.x + this.m_nPosVC, -this.m_ptFrameDepthOffset.y + nLeftBottom, (int)(-1.15 * (double)this.m_ptFrameDepthOffset.x + (double)this.m_nPosVC), (int)(-1.15 * (double)this.m_ptFrameDepthOffset.y + (double)nLeftBottom), null);
            } else {
                this.drawGridline(10000, this.m_nPosVC, nLeftBottom, this.m_nPosVC, nLeftBottom - 250, null);
            }
        }
        if (bRightSide) {
            this.drawGridline(10800, this.m_nPosVC, nRightTop, this.m_nPosVC, nRightTop + 250, null);
        }
    }

    public void calcGridTicksHorizSpanning(boolean bLeftSide, boolean bRightSide) {
        int nLeftBottom = this.m_rFrame.y;
        int nRightTop = this.m_rFrame.height + nLeftBottom;
        if (bLeftSide) {
            if (this.m_bLeftDepthWall || this.m_bRightDepthWall) {
                this.drawGridline(10700, (int)(-((double)this.m_ptFrameDepthOffset.x) / 1.15 + (double)this.m_nPosVC), (int)(-((double)this.m_ptFrameDepthOffset.y) / 1.15 + (double)nLeftBottom), (int)(-1.15 * (double)this.m_ptFrameDepthOffset.x + (double)this.m_nPosVC), (int)(-1.15 * (double)this.m_ptFrameDepthOffset.y + (double)nLeftBottom), null);
            } else {
                this.drawGridline(10000, this.m_nPosVC, nLeftBottom + 250, this.m_nPosVC, nLeftBottom - 250, null);
            }
        }
        if (bRightSide) {
            this.drawGridline(10800, this.m_nPosVC, nRightTop - 250, this.m_nPosVC, nRightTop + 250, null);
        }
    }
}

