/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FontInfoObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DTextDropShadow;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DTextLowLevel;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextRangeCheck;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextStyle2DObj
implements ITextStyle {
    private FontInfoObj m_fontInfo;
    private final Java2DTextLowLevel m_textLowLevel2D;
    private final Java2DTextDropShadow m_textDropShadow2D;

    public TextStyle2DObj(FontInfoObj fontInfo, FontRenderContext frc) {
        this.m_fontInfo = fontInfo;
        this.m_fontInfo.rangeCheckFontInfo();
        this.m_textLowLevel2D = new Java2DTextLowLevel(frc);
        this.m_textDropShadow2D = new Java2DTextDropShadow(this.m_textLowLevel2D);
    }

    private void copyInfoToDrawLevel(VC vc, IBlackBox blackBox) {
        this.m_textLowLevel2D.setFontInfo(this.m_fontInfo, this.getFontSizeDC(vc));
        int nFillType = blackBox.getFillType();
        switch (nFillType) {
            case 1: {
                if (blackBox.getTransparentFillColor()) break;
                this.m_textLowLevel2D.setFillType(1);
                Color col = blackBox.getFillColor();
                this.m_textLowLevel2D.setForegroundColor(col);
                break;
            }
            case 2: {
                this.m_textLowLevel2D.setFillType(2);
                Color colorStart = blackBox.getGradientColorAt(0.0);
                this.m_textLowLevel2D.setGradientStartColor(colorStart);
                Color colorEnd = blackBox.getGradientColorAt(1.0);
                this.m_textLowLevel2D.setGradientEndColor(colorEnd);
                break;
            }
            case 3: {
                this.m_textLowLevel2D.setFillType(3);
                Image textImage = blackBox.getTexture();
                BufferedImage bufImage = this.convertToBufferedImage(textImage);
                this.m_textLowLevel2D.setTexture(bufImage);
            }
        }
        Dimension dimDropShadowDC = blackBox.getDropShadowOffset();
        if (dimDropShadowDC == null) {
            this.m_textDropShadow2D.setDropShadowNone();
        } else {
            this.m_textDropShadow2D.setDropShadowFillType(this.m_fontInfo.m_nDropshadowFillType);
            this.m_textDropShadow2D.setDimensionDropShadowDC(dimDropShadowDC);
            switch (this.m_fontInfo.m_nDropshadowFillType) {
                default: {
                    Color colForeground = blackBox.getDropShadowColor();
                    this.m_textDropShadow2D.setDropShadowForegroundColor(colForeground);
                    break;
                }
                case 2: {
                    this.m_textDropShadow2D.setDropShadowGradientStartColor(this.m_fontInfo.m_colorDropShadowGradientStart);
                    this.m_textDropShadow2D.setDropShadowGradientEndColor(this.m_fontInfo.m_colorDropShadowGradientEnd);
                    break;
                }
                case 3: {
                    if (this.m_fontInfo.m_textureDropShadow == null) {
                        this.m_textDropShadow2D.setDropShadowNone();
                        break;
                    }
                    BufferedImage bufImage = this.convertToBufferedImage(this.m_fontInfo.m_textureDropShadow);
                    this.m_textDropShadow2D.setDropShadowTexture(bufImage);
                }
            }
        }
    }

    private BufferedImage convertToBufferedImage(Image image) {
        Rectangle rImageDC = this.getRectDC();
        BufferedImage bufImage = new BufferedImage(rImageDC.width, rImageDC.height, 1);
        Graphics2D textG = bufImage.createGraphics();
        textG.drawImage(image, 0, 0, rImageDC.width, rImageDC.height, null);
        return bufImage;
    }

    public void setText(String strText) {
        this.m_textLowLevel2D.setText(strText);
    }

    @Override
    public void setRectDC(Rectangle rDC) {
        this.m_textLowLevel2D.setRectDC(rDC);
    }

    @Override
    public void setWordWrap(boolean bWrap) {
        this.m_fontInfo.setWordWrap(bWrap);
        this.m_textLowLevel2D.setWrap(bWrap);
    }

    public void drawText(Graphics2D g, VC vc, IBlackBox blackBox) {
        this.copyInfoToDrawLevel(vc, blackBox);
        assert (false) : "No longer used";
        if (blackBox.getDropShadowOffset() == null) {
            this.m_textLowLevel2D.drawText(g, null);
        } else {
            this.m_textDropShadow2D.drawText(g);
        }
    }

    public void drawText(Graphics2D g, VC vc, IBlackBox blackBox, Rectangle rectDC, List<String> text) {
        this.setRectDC(rectDC);
        this.copyInfoToDrawLevel(vc, blackBox);
        this.m_textLowLevel2D.drawText(g, text);
    }

    @Override
    public double getFontSizeDC(VC vc) {
        double nFontSizeDC = this.m_fontInfo.m_bUseDC ? (double)this.m_fontInfo.m_nFontSizeDC : (double)vc.virtToDestHeight(this.m_fontInfo.m_nFontSizeVC);
        nFontSizeDC = TextRangeCheck.rangeChkFontPtSize(nFontSizeDC);
        return nFontSizeDC;
    }

    @Override
    public int getFontSizeVC(VC vc) {
        int nFontSizeVC = this.m_fontInfo.m_bUseDC ? vc.destToVirtHeight(this.m_fontInfo.m_nFontSizeDC) : this.m_fontInfo.m_nFontSizeVC;
        nFontSizeVC = TextRangeCheck.rangeChkFontVCSize(this.m_fontInfo.m_nFontSizeVC);
        return nFontSizeVC;
    }

    @Override
    public boolean getWordWrap() {
        return this.m_fontInfo.m_bWordwrap;
    }

    @Override
    public Rectangle getRectDC() {
        Rectangle rDC = new Rectangle(this.m_textLowLevel2D.getRectDC());
        return rDC;
    }

    @Override
    public void setRotationSetting(int nRotationSetting) {
        this.m_fontInfo.setRotationSetting(nRotationSetting);
    }

    @Override
    public int getRotationSetting() {
        return this.m_fontInfo.m_nRotationSetting;
    }

    @Override
    public void setHorizAlign(int nAlignH) {
        this.m_fontInfo.setHorizAlign(nAlignH);
    }

    @Override
    public Dimension getTextSizeDC(String strText) {
        return this.getTextSizeDC(strText, this.m_fontInfo.m_nFontSizeDC, new Dimension(100000, 100000), null, this.m_fontInfo.m_bWordwrap);
    }

    @Override
    public Dimension getTextSizeDC(String strText, double nFontSizeDC, Dimension dimMaxDC, Dimension dropShadowOffset, boolean bWordwrap) {
        double nSaveFontPointSize = this.m_textLowLevel2D.getFontPointSize();
        Rectangle rSaveTextDC = this.m_textLowLevel2D.getRectDC();
        this.m_textLowLevel2D.setFontInfo(this.m_fontInfo, nFontSizeDC);
        this.m_textLowLevel2D.setText(strText);
        this.m_textLowLevel2D.setWrap(bWordwrap);
        Rectangle rWrappedTextDC = new Rectangle(rSaveTextDC);
        rWrappedTextDC.width = dimMaxDC.width;
        rWrappedTextDC.height = dimMaxDC.height;
        this.m_textLowLevel2D.setRectDC(rWrappedTextDC);
        Dimension dimTextDC = this.m_textLowLevel2D.getTextSizeDC();
        this.m_textLowLevel2D.setRectDC(rSaveTextDC);
        this.m_textLowLevel2D.setFontPointSize(nSaveFontPointSize);
        return dimTextDC;
    }

    @Override
    public boolean useAccurateTextSizeCalculation(boolean bAccurate) {
        return this.m_textLowLevel2D.useAccurateTextSizeCalculation(bAccurate);
    }

    @Override
    public List<String> getWrappedTextList(Perspective p, String text, Dimension dimMaxVC) {
        this.m_textLowLevel2D.setFontInfo(this.m_fontInfo, this.m_fontInfo.m_nFontSizeDC);
        this.m_textLowLevel2D.setText(text);
        this.m_textLowLevel2D.setWrap(this.m_fontInfo.m_bWordwrap);
        Rectangle rWrappedTextDC = new Rectangle(this.m_textLowLevel2D.getRectDC());
        rWrappedTextDC.setSize(p.getVC().virtToDest(dimMaxVC));
        this.m_textLowLevel2D.setRectDC(rWrappedTextDC);
        return this.m_textLowLevel2D.getListOfWrappedTextLines();
    }
}

