/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DTextLowLevel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

class Java2DTextDropShadow {
    private final Java2DTextLowLevel m_textLowLevel2D;
    private Color m_colorDropForeground = new Color(0, 255, 0);
    private Dimension m_dimDropShadowOffset = new Dimension(2, 2);
    private Color m_colorDropShadowGradientStart = Color.blue;
    private Color m_colorDropShadowGradientEnd = Color.green;
    private int m_nDropShadowFillType = 1;
    private transient BufferedImage m_textureDropShadow;

    public Java2DTextDropShadow(Java2DTextLowLevel textLowLevel) {
        this.m_textLowLevel2D = textLowLevel;
    }

    public void setDropShadowFillType(int nFillType) {
        this.m_nDropShadowFillType = nFillType;
    }

    public void setDropShadowForegroundColor(Color col) {
        this.m_colorDropForeground = new Color(col.getRed(), col.getGreen(), col.getBlue());
    }

    public void setDimensionDropShadowDC(Dimension dim) {
        this.m_dimDropShadowOffset = new Dimension(dim);
    }

    public void setDropShadowNone() {
        this.m_dimDropShadowOffset = new Dimension(0, 0);
    }

    public void setDropShadowOffset(Dimension dimOffset) {
        this.m_dimDropShadowOffset = new Dimension(dimOffset);
    }

    public void setDropShadowGradientStartColor(Color colorStart) {
        this.m_colorDropShadowGradientStart = new Color(colorStart.getRed(), colorStart.getGreen(), colorStart.getBlue(), colorStart.getAlpha());
    }

    public void setDropShadowGradientEndColor(Color colorEnd) {
        this.m_colorDropShadowGradientEnd = new Color(colorEnd.getRed(), colorEnd.getGreen(), colorEnd.getBlue(), colorEnd.getAlpha());
    }

    public void setDropShadowTexture(BufferedImage img) {
        this.m_textureDropShadow = img;
    }

    public void drawText(Graphics2D g) {
        if (this.m_dimDropShadowOffset.width > 0 || this.m_dimDropShadowOffset.height > 0) {
            Rectangle rSaveTextDC = this.m_textLowLevel2D.getRectDC();
            int nSaveFillType = this.m_textLowLevel2D.getFillType();
            Color colorSaveForeground = this.m_textLowLevel2D.getForegroundColor();
            boolean bSaveUseBackgroundColor = this.m_textLowLevel2D.getUseBackgroundColor();
            Color colorSaveGradStart = this.m_textLowLevel2D.getGradientStartColor();
            Color colorSaveGradEnd = this.m_textLowLevel2D.getGradientEndColor();
            BufferedImage saveTexture = this.m_textLowLevel2D.getTexture();
            this.drawFrontDropShadowText(g, rSaveTextDC);
            this.m_textLowLevel2D.setRectDC(rSaveTextDC);
            this.m_textLowLevel2D.setFillType(nSaveFillType);
            this.m_textLowLevel2D.setForegroundColor(colorSaveForeground);
            this.m_textLowLevel2D.setUseBackgroundColor(bSaveUseBackgroundColor);
            this.m_textLowLevel2D.setGradientStartColor(colorSaveGradStart);
            this.m_textLowLevel2D.setGradientEndColor(colorSaveGradEnd);
            this.m_textLowLevel2D.setTexture(saveTexture);
        }
        this.m_textLowLevel2D.drawText(g, null);
    }

    private void drawFrontDropShadowText(Graphics2D g, Rectangle rSaveTextDC) {
        Rectangle rDropShadowDC = new Rectangle(rSaveTextDC.x + this.m_dimDropShadowOffset.width, rSaveTextDC.y + this.m_dimDropShadowOffset.height, rSaveTextDC.width, rSaveTextDC.height);
        this.m_textLowLevel2D.setRectDC(rDropShadowDC);
        this.m_textLowLevel2D.setFillType(this.m_nDropShadowFillType);
        this.m_textLowLevel2D.setUseBackgroundColor(false);
        switch (this.m_nDropShadowFillType) {
            case 1: {
                this.m_textLowLevel2D.setForegroundColor(this.m_colorDropForeground);
                break;
            }
            case 2: {
                this.m_textLowLevel2D.setGradientStartColor(this.m_colorDropShadowGradientStart);
                this.m_textLowLevel2D.setGradientEndColor(this.m_colorDropShadowGradientEnd);
                break;
            }
            case 3: {
                this.m_textLowLevel2D.setTexture(this.m_textureDropShadow);
            }
        }
        this.m_textLowLevel2D.drawText(g, null);
    }
}

