/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

class DetRect
extends DetObj {
    private Rectangle m_rBounds;
    private boolean m_bDotted = false;

    DetRect(IDrawContainer container, IdentObj id, int x, int y, int width, int height, IBlackBox blackBox, boolean bDotted) {
        this(container, id, x, y, width, height, blackBox, null);
        this.m_bDotted = bDotted;
    }

    DetRect(IDrawContainer container, IdentObj id, int x, int y, int width, int height, IBlackBox blackBox) {
        this(container, id, x, y, width, height, blackBox, null);
    }

    DetRect(IDrawContainer container, IdentObj id, Rectangle r, IBlackBox blackBox, Rectangle clipRect) {
        this(container, id, r.x, r.y, r.width, r.height, blackBox, clipRect);
    }

    DetRect(IDrawContainer container, IdentObj id, int x, int y, int width, int height, IBlackBox blackBox, Rectangle clipRect) {
        super(container, id, blackBox, clipRect);
        this.m_rBounds = new Rectangle(x, y, width, height);
    }

    public void hilite(Graphics2D g, VC vc) {
        Rectangle dest = vc.virtToDest(this.m_rBounds);
        g.setXORMode(Color.yellow);
        g.drawRect(dest.x, dest.y, dest.width, dest.height);
        g.setPaintMode();
    }

    public void paintIt(Graphics2D g, VC vc) {
        if (this.clipRect != null) {
            Rectangle rClip = vc.virtToDest(this.clipRect);
            Shape shape = g.getClip();
            g.setClip(rClip);
            if (this.m_bDotted) {
                this.blackBox.paintRectDotted(g, vc.virtToDest(this.m_rBounds), true, true);
            } else {
                this.blackBox.paintRect(g, vc.virtToDest(this.m_rBounds));
            }
            g.setClip(shape);
        } else if (this.m_bDotted) {
            this.blackBox.paintRectDotted(g, vc.virtToDest(this.m_rBounds), true, true);
        } else {
            this.blackBox.paintRect(g, vc.virtToDest(this.m_rBounds));
        }
    }

    public Shape getShape() {
        return this.m_rBounds;
    }
}

