/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.IScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utilities.OutOfRangeException;

public class ScaleLog
implements IScale {
    public static final double MIN_SCALE_BASE = 2.0;
    public static final double MAX_SCALE_BASE = 100.0;
    public static final boolean DEBUG = true;
    private final double m_dScaleBase;
    private final double m_dMinValue;
    private final double m_dMaxValue;
    private final double m_dLogScaleBase;
    private final double m_dLogMinValue;
    private final double m_dLogMaxValue;
    private final double m_dLogScaleRange;

    public ScaleLog(double dMinValue, double dMaxValue) {
        this(dMinValue, dMaxValue, 10.0);
    }

    public ScaleLog(double dMinValue, double dMaxValue, double dScaleBase) {
        assert (!(Double.isNaN(dMinValue) || Double.isNaN(dMaxValue) || Double.isNaN(dScaleBase)));
        assert (dMinValue != 7.7777777E307 && dMaxValue != 7.7777777E307);
        assert (dScaleBase >= 2.0 && dScaleBase <= 100.0);
        this.m_dScaleBase = dScaleBase;
        this.m_dLogScaleBase = Math.log(this.m_dScaleBase);
        if (dMaxValue <= dMinValue || dMinValue <= 0.0) {
            throw new IllegalArgumentException("new LinearScale: dMinValue must be less than dMaxValue.");
        }
        this.m_dMinValue = dMinValue;
        this.m_dMaxValue = dMaxValue;
        this.m_dLogMinValue = Math.log(this.m_dMinValue) / this.m_dLogScaleBase;
        this.m_dLogMaxValue = Math.log(this.m_dMaxValue) / this.m_dLogScaleBase;
        this.m_dLogScaleRange = this.m_dLogMaxValue - this.m_dLogMinValue;
        assert (this.m_dLogScaleRange > 0.0);
    }

    public double getMinValue() {
        return this.m_dMinValue;
    }

    public double getMaxValue() {
        return this.m_dMaxValue;
    }

    public boolean containsValue(double dValue) {
        return dValue >= this.m_dMinValue && dValue <= this.m_dMaxValue;
    }

    public double unitToValue(double dUnit) throws OutOfRangeException {
        return this.unitToValue(dUnit, false);
    }

    public double unitToValue(double dUnit, boolean bAllowExtrapolation) throws OutOfRangeException {
        if ((dUnit < 0.0 || dUnit > 1.0) && !bAllowExtrapolation) {
            throw new OutOfRangeException(0.0, 1.0, dUnit);
        }
        double dLogValue = this.m_dLogMinValue + dUnit * this.m_dLogScaleRange;
        double dValue = Math.pow(this.m_dScaleBase, dLogValue);
        return dValue;
    }

    public double valueToUnit(double dValue) throws OutOfRangeException {
        return this.valueToUnit(dValue, false);
    }

    public double valueToUnit(double dValue, boolean bAllowExtrapolation) throws OutOfRangeException {
        if ((dValue < this.m_dMinValue || dValue > this.m_dMaxValue) && !bAllowExtrapolation) {
            throw new OutOfRangeException(this.m_dMinValue, this.m_dMaxValue, dValue);
        }
        double dLogValue = Math.log(dValue) / this.m_dLogScaleBase;
        double dUnit = (dLogValue - this.m_dLogMinValue) / this.m_dLogScaleRange;
        return dUnit;
    }
}

