/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.businessobjects.visualization.map.IGraphicMap;
import com.businessobjects.visualization.pfjgraphics.PFJEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Detectiv;
import com.businessobjects.visualization.rendering.RenderEngine;
import java.awt.Graphics2D;

public class PFJRenderEngine
extends RenderEngine {
    private PFJEngine pfjEngine;
    private Detectiv detectiv;
    private int outputType;
    private int width;
    private int height;
    private int twipwidth;
    private int twipheight;

    public PFJRenderEngine(PFJEngine engine, Detectiv d, int outputType) {
        super(outputType, null, null);
        this.pfjEngine = engine;
        this.detectiv = d;
        this.outputType = outputType;
        this.width = this.pfjEngine.getWidthDC();
        this.height = this.pfjEngine.getHeidthDC();
        this.twipwidth = this.pfjEngine.getWidthTwips();
        this.twipheight = this.pfjEngine.getHeightTwips();
    }

    public byte[] render() {
        return this.pfjEngine.render(this.detectiv, this.width, this.height, this.twipwidth, this.twipheight, this.outputType);
    }

    public boolean nativeRender(Object graphObject, boolean bSynchronous) {
        this.pfjEngine.render(this.detectiv, (Graphics2D)graphObject);
        return true;
    }

    public IGraphicMap getGraphicMap() {
        IGraphicMap map = super.getGraphicMap();
        if (map == null) {
            map = this.pfjEngine.generateGraphicMap(this.detectiv, this.twipwidth, this.twipheight);
            this.setGraphicMap(map);
        }
        return map;
    }
}

