/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.businessobjects.visualization.GraphicInstance;

public class PFJDriverUtils {
    private static final String[] XYStyleDimensionFeeds = new String[]{"SeriesLabels", "AxisLabels"};
    private static final String[] ProportionialStyleDimensionFeeds = new String[]{"PieceLabels", "ChartLabels"};
    private static final String[] ScatterStyleDimensionFeeds = new String[]{"SeriesLabels", "GroupLabels"};
    private static final String[] StockStyleDimensionFeeds = new String[]{"SeriesLabels", "AxisLabels"};
    private static final String[] GanttStyleDimensionFeeds = new String[]{"NONE", "TaskLabels"};
    private static final String[] XYStyleMeasureFeeds = new String[]{"PrimaryValues"};
    private static final String[] ProportionalStyleMeasureFeeds = new String[]{"PieceValues"};
    private static final String[] ScatterStyleMeasureFeeds = new String[]{"XAxis", "YAxis", "BubbleSize"};
    private static final String[] StockStyleMeasureFeeds = new String[]{"High", "Low", "Open", "Close"};
    private static final String[] GanttStyleMeasureFeeds = new String[]{"Start", "End"};

    public static String getDimensionFeedDefID(GraphicInstance graphicInstance, PFJAxisType axisType) {
        String dataFeedDefinitionID = graphicInstance.getFeeder().getDataFeedDefinition().getId();
        String[] dimensionFeeds = PFJDriverUtils.getDimensionFeedIDs(dataFeedDefinitionID);
        return dimensionFeeds[axisType.ordinal()];
    }

    public static PFJAxisType getPFJAxisType(GraphicInstance graphicInstance, String dimensionFeedID) {
        String dataFeedDefinitionID = graphicInstance.getFeeder().getDataFeedDefinition().getId();
        String[] dimensionFeeds = PFJDriverUtils.getDimensionFeedIDs(dataFeedDefinitionID);
        if (dimensionFeeds[PFJAxisType.Series.ordinal()].equals(dimensionFeedID)) {
            return PFJAxisType.Series;
        }
        if (dimensionFeeds[PFJAxisType.Group.ordinal()].equals(dimensionFeedID)) {
            return PFJAxisType.Group;
        }
        return null;
    }

    public static int getMeasureIndex(GraphicInstance graphicInstance, String feedDefID) {
        String dataFeedDefinitionID = graphicInstance.getFeeder().getDataFeedDefinition().getId();
        String[] measureFeeds = PFJDriverUtils.getMeasureFeedIDs(dataFeedDefinitionID);
        for (int i = 0; i < measureFeeds.length; ++i) {
            String measureFeedID = measureFeeds[i];
            if (!feedDefID.equals(measureFeedID)) continue;
            return i;
        }
        return -1;
    }

    public static String getMeasureFeedDefID(GraphicInstance graphicInstance, int index) {
        String dataFeedDefinitionID = graphicInstance.getFeeder().getDataFeedDefinition().getId();
        int numDataItems = PFJDriverUtils.getNumDataItems(graphicInstance);
        int i = index % numDataItems;
        return PFJDriverUtils.getMeasureFeedIDs(dataFeedDefinitionID)[i];
    }

    private static String[] getDimensionFeedIDs(String dataFeedDefinitionID) {
        if (dataFeedDefinitionID.equals("PFJXYStyleFeed")) {
            return XYStyleDimensionFeeds;
        }
        if (dataFeedDefinitionID.equals("PFJProportionalStyleFeed")) {
            return ProportionialStyleDimensionFeeds;
        }
        if (dataFeedDefinitionID.equals("PFJScatterStyleFeed")) {
            return ScatterStyleDimensionFeeds;
        }
        if (dataFeedDefinitionID.equals("PFJStockStyleFeed")) {
            return StockStyleDimensionFeeds;
        }
        if (dataFeedDefinitionID.equals("PFJGanttStyleFeed")) {
            return GanttStyleDimensionFeeds;
        }
        return null;
    }

    public static String[] getMeasureFeedIDs(String dataFeedDefinitionID) {
        if (dataFeedDefinitionID.equals("PFJXYStyleFeed")) {
            return XYStyleMeasureFeeds;
        }
        if (dataFeedDefinitionID.equals("PFJProportionalStyleFeed")) {
            return ProportionalStyleMeasureFeeds;
        }
        if (dataFeedDefinitionID.equals("PFJGanttStyleFeed")) {
            return GanttStyleMeasureFeeds;
        }
        if (dataFeedDefinitionID.equals("PFJScatterStyleFeed")) {
            return ScatterStyleMeasureFeeds;
        }
        if (dataFeedDefinitionID.equals("PFJStockStyleFeed")) {
            return StockStyleMeasureFeeds;
        }
        return null;
    }

    private static int getNumDataItems(GraphicInstance graphicInstance) {
        String graphID = graphicInstance.getPublicGraphicId();
        if (graphID.endsWith("scatter") || graphID.endsWith("numeric_x_bar") || graphID.endsWith("numeric_x_line") || graphID.endsWith("numeric_x_surface") || graphID.endsWith("gantt_start_end") || graphID.endsWith("stock_hl")) {
            return 2;
        }
        if (graphID.endsWith("bubble") || graphID.endsWith("stock_hlo") || graphID.endsWith("stock_hlc")) {
            return 3;
        }
        if (graphID.endsWith("stock_hloc")) {
            return 4;
        }
        return 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PFJAxisType {
        Series,
        Group;


        public boolean isSeries() {
            return this == Series;
        }
    }
}

