/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.businessobjects.visualization.common.internal.Base64Coder;
import com.businessobjects.visualization.dataexchange.DimensionLabelsContext;
import com.businessobjects.visualization.dataexchange.MeasureValuesContext;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.graphic.IRegion;
import com.businessobjects.visualization.graphic.VisuString;
import com.businessobjects.visualization.pfjgraphics.DataHandlerContainer;
import com.businessobjects.visualization.pfjgraphics.DimensionLabelsHandler;
import com.businessobjects.visualization.pfjgraphics.MeasureValuesHandler;
import com.businessobjects.visualization.pfjgraphics.PFJChartType;
import com.businessobjects.visualization.pfjgraphics.PFJDriverUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PFJDataEngine {
    protected Perspective pfj;
    protected CVOMHelper cvom;
    protected PFJChartType chartType;
    protected boolean isMultiDataItem;
    protected int numDataItems;
    DataHandlerContainer dataHandlerContainer = null;
    DimensionLabelsHandler seriesLabelsHandler = null;
    DimensionLabelsHandler groupLabelsHandler = null;
    List<MeasureValuesHandler> measureHandlers = null;

    PFJDataEngine(CVOMHelper cvom, Perspective pfj, PFJChartType chartType) {
        this.cvom = cvom;
        this.pfj = pfj;
        this.isMultiDataItem = chartType.isMultiDataType();
    }

    private void initHandlers() {
        this.dataHandlerContainer = new DataHandlerContainer(this.cvom.context);
        this.seriesLabelsHandler = this.dataHandlerContainer.getSeriesDimensionLabelsHandler();
        this.groupLabelsHandler = this.dataHandlerContainer.getGroupDimensionLabelsHandler();
        this.measureHandlers = this.dataHandlerContainer.getMeasureValueHandlers();
        HashSet<String> feedDefs = new HashSet<String>();
        for (MeasureValuesHandler mvh : this.measureHandlers) {
            feedDefs.add(mvh.getFeedDefID());
        }
        this.numDataItems = feedDefs.size();
    }

    protected void sendData() {
        this.initHandlers();
        if (!this.setDataRange()) {
            return;
        }
        this.processLabels();
        this.setDataZone();
    }

    protected boolean setDataRange() {
        if (this.measureHandlers == null || this.measureHandlers.size() == 0 || this.measureHandlers.get(0) == null) {
            return false;
        }
        int numRows = this.getNumRows();
        int numColumns = this.getNumColumns();
        if (0 == numRows || 0 == numColumns) {
            return false;
        }
        this.pfj.useFastDoubleDataStorage(numRows, numColumns);
        this.pfj.setDataRange(0, 0, numRows - 1, numColumns - 1);
        return true;
    }

    private int getNumRows() {
        if (this.seriesLabelsHandler != null) {
            return this.seriesLabelsHandler.getNumLabels();
        }
        return this.measureHandlers.size() / this.numDataItems;
    }

    private int getNumColumns() {
        if (this.groupLabelsHandler != null) {
            return this.groupLabelsHandler.getNumLabels() * this.numDataItems;
        }
        return this.measureHandlers.size();
    }

    public void setDataZone() {
        if (this.measureHandlers.get(0) == null) {
            return;
        }
        for (MeasureValuesHandler mvh : this.measureHandlers) {
            int currentDataItemIndex = PFJDriverUtils.getMeasureIndex(this.cvom.context, mvh.getFeedDefID());
            boolean rowIsSeries = mvh.rowIsSeries();
            int cardinality = mvh.getCardinality();
            int numRows = mvh.getNumDataRows();
            for (int i = 0; i < numRows; ++i) {
                double[] dataRow = mvh.getDataRow(i);
                for (int j = 0; j < dataRow.length; ++j) {
                    if (this.isMultiDataItem) {
                        if (rowIsSeries) {
                            if (cardinality == 1) {
                                this.setData(mvh.getIndex(), j * this.numDataItems + currentDataItemIndex, dataRow[j]);
                                continue;
                            }
                            this.setData(i, j * this.numDataItems + currentDataItemIndex, dataRow[j]);
                            continue;
                        }
                        if (cardinality == 1) {
                            this.setData(j, mvh.getIndex() * this.numDataItems + currentDataItemIndex, dataRow[j]);
                            continue;
                        }
                        this.setData(j, i * this.numDataItems + currentDataItemIndex, dataRow[j]);
                        continue;
                    }
                    if (rowIsSeries) {
                        if (cardinality == 1) {
                            this.setData(mvh.getIndex(), j, dataRow[j]);
                            continue;
                        }
                        this.setData(i, j, dataRow[j]);
                        continue;
                    }
                    if (cardinality == 1) {
                        this.setData(j, mvh.getIndex(), dataRow[j]);
                        continue;
                    }
                    this.setData(j, i, dataRow[j]);
                }
            }
        }
    }

    protected void processLabels() {
        List<String> titles;
        int i = 0;
        if (this.groupLabelsHandler != null) {
            for (String label : this.groupLabelsHandler.getLabels()) {
                this.pfj.setGroupLabel(i++, label);
            }
        } else {
            titles = this.getTitlesFromMeasureHandlers(this.measureHandlers);
            for (String title : titles) {
                this.pfj.setGroupLabel(i++, title);
            }
        }
        i = 0;
        if (this.seriesLabelsHandler != null) {
            for (String label : this.seriesLabelsHandler.getLabels()) {
                this.pfj.setSeriesLabel(i++, label);
            }
        } else {
            titles = this.getTitlesFromMeasureHandlers(this.measureHandlers);
            for (String title : titles) {
                this.pfj.setSeriesLabel(i++, title);
            }
        }
    }

    private List<String> getTitlesFromMeasureHandlers(List<MeasureValuesHandler> measureHandlers) {
        String dataFeedDefinitionID = this.cvom.context.getFeeder().getDataFeedDefinition().getId();
        String[] measureFeedIDs = PFJDriverUtils.getMeasureFeedIDs(dataFeedDefinitionID);
        String feedDefID = dataFeedDefinitionID.equals("PFJScatterStyleFeed") ? measureFeedIDs[1] : measureFeedIDs[0];
        ArrayList<String> titles = new ArrayList<String>();
        for (MeasureValuesHandler measureHandler : this.dataHandlerContainer.getMeasureValueHandlers(feedDefID)) {
            titles.add(measureHandler.getTitle());
        }
        return titles;
    }

    protected void setData(int row, int col, double data) {
        if (1.7E308 != data) {
            this.pfj.setData(row, col, data);
        } else {
            this.pfj.setNullData(row, col);
        }
    }

    protected void setDataRow(int row, double[] data) {
        int col = 0;
        for (double d : data) {
            this.setData(row, col++, d);
        }
    }

    public MeasureValuesContext[] getMeasureValuesContexts(int series, int group) {
        MeasureValuesContext[] measureValuesContexts = null;
        if (this.isMultiDataItem) {
            measureValuesContexts = new MeasureValuesContext[this.measureHandlers.size()];
            int i = 0;
            for (MeasureValuesHandler mvh : this.measureHandlers) {
                measureValuesContexts[i++] = new MeasureValuesContext(mvh.getMeasureValues());
            }
        } else if (series != -3) {
            int measureIndex;
            measureValuesContexts = new MeasureValuesContext[1];
            boolean hasSeriesHandler = this.seriesLabelsHandler != null;
            MeasureValues measureValues = null;
            int n = measureIndex = hasSeriesHandler ? 0 : series;
            if (measureIndex < this.measureHandlers.size() && measureIndex >= 0) {
                measureValues = this.measureHandlers.get(measureIndex).getMeasureValues();
            }
            double value = group == -3 ? Double.NaN : this.pfj.getAccess().getDataAsDouble(series, group, DataItem.DI_GENERAL);
            measureValuesContexts[0] = new MeasureValuesContext(value, measureValues, null);
        }
        return measureValuesContexts;
    }

    public DimensionLabelsContext[] getDimensionLabelsContexts(int series, int group) {
        ArrayList<DimensionLabelsContext> list = new ArrayList<DimensionLabelsContext>();
        if (this.seriesLabelsHandler != null && series != -3) {
            list.add(new DimensionLabelsContext((Object)this.pfj.getSeriesLabel(series), 0, null, this.seriesLabelsHandler.getDimensionLabels()));
        }
        if (this.groupLabelsHandler != null && group != -3) {
            list.add(new DimensionLabelsContext((Object)this.pfj.getGroupLabel(group), 0, null, this.groupLabelsHandler.getDimensionLabels()));
        }
        DimensionLabelsContext[] dc = new DimensionLabelsContext[list.size()];
        return list.toArray(dc);
    }

    public int[] getAxisIndexes(int series, int group) {
        int[] indexes = new int[this.getNumDimensions()];
        if (this.groupLabelsHandler != null) {
            indexes[0] = group;
        }
        if (this.seriesLabelsHandler != null) {
            if (this.groupLabelsHandler == null) {
                indexes[0] = series;
            } else {
                indexes[1] = series;
            }
        }
        return indexes;
    }

    private int getNumDimensions() {
        int numDimensions = 0;
        if (this.groupLabelsHandler != null) {
            ++numDimensions;
        }
        if (this.seriesLabelsHandler != null) {
            ++numDimensions;
        }
        return numDimensions;
    }

    public void setHighlights() {
        IRegion hlRegion = this.cvom.context.getRegion("root/highlights");
        String colorData = ((VisuString)hlRegion.getPropertyValue("originalcolors")).toString();
        this.initOriginalColors(colorData);
        String highlightData = ((VisuString)hlRegion.getPropertyValue("dataitemhighlights")).toString();
        if (highlightData.length() == 0) {
            return;
        }
        boolean colorByGroup = this.pfj.isColorByGroup();
        int nSeries = this.pfj.getNumSeries();
        int nGroups = this.pfj.getNumGroups();
        HL[] seriesHL = new HL[this.pfj.getNumSeries()];
        HL[] groupHL = new HL[this.pfj.getNumGroups()];
        LinkedList<HL> miscHL = new LinkedList<HL>();
        byte[] buffer = Base64Coder.decode((String)highlightData);
        for (int i = 0; i < buffer.length / 16; ++i) {
            HL hl = new HL(buffer, i * 16);
            if (hl.group == -1) {
                seriesHL[hl.series] = hl;
                continue;
            }
            if (hl.series == -1) {
                groupHL[hl.group] = hl;
                continue;
            }
            miscHL.add(hl);
        }
        if (colorByGroup) {
            for (HL hl : groupHL) {
                if (hl == null) continue;
                this.pfj.setColorHighlight(hl.group, hl.color);
            }
        } else {
            for (HL hl : seriesHL) {
                if (hl == null) continue;
                this.pfj.setColorHighlight(hl.series, hl.color);
            }
        }
        for (int s = 0; s < nSeries; ++s) {
            for (int g = 0; g < nGroups; ++g) {
                if (colorByGroup && seriesHL[s] != null && seriesHL[s].higher(groupHL[g])) {
                    this.pfj.setColorHighlight(s, g, seriesHL[s].color);
                    continue;
                }
                if (colorByGroup || groupHL[g] == null || !groupHL[g].higher(seriesHL[s])) continue;
                this.pfj.setColorHighlight(s, g, groupHL[g].color);
            }
        }
        for (HL hl : miscHL) {
            if (hl == null || !hl.higher(seriesHL[hl.series]) || !hl.higher(groupHL[hl.group])) continue;
            this.pfj.setColorHighlight(hl.series, hl.group, hl.color);
        }
    }

    private static Color decodeColor(byte[] buffer, int idx) {
        return new Color(PFJDataEngine.decodeInt(buffer, idx), true);
    }

    private static int decodeInt(byte[] buffer, int idx) {
        return (buffer[idx] & 0xFF) << 24 | (buffer[idx + 1] & 0xFF) << 16 | (buffer[idx + 2] & 0xFF) << 8 | buffer[idx + 3] & 0xFF;
    }

    void initOriginalColors(String colorData) {
        if (colorData.length() == 0) {
            return;
        }
        byte[] buffer = Base64Coder.decode((String)colorData);
        int nColors = buffer.length / 4;
        this.pfj.setSeriesLooping(nColors);
        for (int i = 0; i < nColors; ++i) {
            this.pfj.setSeriesFillColor(i, PFJDataEngine.decodeColor(buffer, i * 4));
        }
    }

    class HL {
        int group;
        int series;
        Color color;
        int priority;

        HL(byte[] buffer, int idx) {
            this.group = PFJDataEngine.decodeInt(buffer, idx);
            this.series = PFJDataEngine.decodeInt(buffer, idx + 4);
            this.color = PFJDataEngine.decodeColor(buffer, idx + 8);
            this.priority = PFJDataEngine.decodeInt(buffer, idx + 12);
        }

        boolean higher(HL other) {
            return other == null || other.priority > this.priority;
        }
    }
}

