/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.dataexchange.definition.DataContainer;
import com.businessobjects.visualization.feed.DataFeed;
import com.businessobjects.visualization.feed.Feed;
import com.businessobjects.visualization.feed.definition.DataContainerType;
import com.businessobjects.visualization.pfjgraphics.DimensionLabelsHandler;
import com.businessobjects.visualization.pfjgraphics.MeasureValuesHandler;
import com.businessobjects.visualization.pfjgraphics.PFJDriverUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataHandlerContainer {
    protected GraphicInstance graphicInstance;
    private String seriesFeedID;
    private String groupFeedID;
    private DimensionLabelsHandler seriesDimensionLabelsHandler;
    private DimensionLabelsHandler groupDimensionLabelsHandler;
    private List<MeasureValuesHandler> measureHandlers;

    public DataHandlerContainer(GraphicInstance aContext) {
        this.graphicInstance = aContext;
        this.seriesFeedID = PFJDriverUtils.getDimensionFeedDefID(this.graphicInstance, PFJDriverUtils.PFJAxisType.Series);
        this.groupFeedID = PFJDriverUtils.getDimensionFeedDefID(this.graphicInstance, PFJDriverUtils.PFJAxisType.Group);
    }

    List<MeasureValuesHandler> getMeasureValueHandlers(String feedDefID) {
        ArrayList<MeasureValuesHandler> newMeasureHandlers = new ArrayList<MeasureValuesHandler>();
        List<MeasureValuesHandler> mvhs = this.getMeasureValueHandlers();
        for (MeasureValuesHandler mvh : mvhs) {
            if (!mvh.getFeedDefID().equals(feedDefID)) continue;
            newMeasureHandlers.add(mvh);
        }
        return newMeasureHandlers;
    }

    List<MeasureValuesHandler> getMeasureValueHandlers() {
        if (this.measureHandlers == null) {
            String[] measureFeedIDs;
            this.measureHandlers = new ArrayList<MeasureValuesHandler>();
            DataFeed dataFeed = this.graphicInstance.getFeeder().getCurrentDataFeed();
            for (String measureFeedID : measureFeedIDs = PFJDriverUtils.getMeasureFeedIDs(this.graphicInstance.getFeeder().getDataFeedDefinition().getId())) {
                Feed[] feeds = dataFeed.findByDefId(measureFeedID, DataContainerType.MEASUREVALUES);
                for (int i = 0; i < feeds.length; ++i) {
                    this.measureHandlers.add(this.getMeasureValuesHandler(feeds[i], i));
                }
            }
        }
        return this.measureHandlers;
    }

    public DimensionLabelsHandler getSeriesDimensionLabelsHandler() {
        DataContainer dc;
        if (this.seriesDimensionLabelsHandler == null && (dc = this.findDataContainer(this.seriesFeedID)) != null) {
            this.seriesDimensionLabelsHandler = new DimensionLabelsHandler(this.graphicInstance, dc);
        }
        return this.seriesDimensionLabelsHandler;
    }

    public DimensionLabelsHandler getGroupDimensionLabelsHandler() {
        DataContainer dc;
        if (this.groupDimensionLabelsHandler == null && (dc = this.findDataContainer(this.groupFeedID)) != null) {
            this.groupDimensionLabelsHandler = new DimensionLabelsHandler(this.graphicInstance, dc);
        }
        return this.groupDimensionLabelsHandler;
    }

    private DataContainer findDataContainer(String feedID) {
        DataFeed dataFeed = this.graphicInstance.getFeeder().getCurrentDataFeed();
        for (Feed feed : dataFeed.getFeeds()) {
            if (!feed.getFeedDef().getId().equals(feedID)) continue;
            return feed.getDataContainers()[0];
        }
        return null;
    }

    private MeasureValuesHandler getMeasureValuesHandler(Feed feed, int index) {
        boolean rowsAreSeries = this.groupDimensionLabelsHandler != null && this.groupDimensionLabelsHandler.getAnalysisAxisIndex() == 0;
        return new MeasureValuesHandler(feed, rowsAreSeries, this.graphicInstance, index);
    }
}

